import 'package:dartz/dartz.dart';
import '../../core/errors/failure.dart';
import '../../domain/interfaces/payment_method_service_interface.dart';
import '../models/payment_methods_model/payment_methods_model.dart';
import 'base_repository.dart';
import 'interfaces/payment_methods_repo_interface.dart';

class PaymentMethodsRepoImpl extends BaseRepository implements IPaymentMethodsRepo {
  final IPaymentMethodsService paymentMethodsService;

  PaymentMethodsRepoImpl({required this.paymentMethodsService});
  @override
  Future<Either<Failure, PaymentMethodsModel>> getPaymentMethods() async => await safeApiCall(() async {
      final response = await paymentMethodsService.getPaymentMethods();
      return PaymentMethodsModel.fromJson(response.data);
    });

}
